clear, clc,close all
% Define the grid and the "continuous" function sin
x=0:0.01:2*pi;
y=sin(x);
% Plot the points (x,sin(x))
plot(x,y,'.');

pause
figure
plot(x,y);
% Set the axis boundaries. Note: The data should not touch the axis, therefore
% the y axis is set to be -1.05 to 1.05.
axis([0 2*pi -1.05 1.05])
% Add a label for the x-axis
xlabel('x');
% Add a label for the y-axis
ylabel('sin(x)');
% Add a title for the y-axis
title('sine function graphic')


pause
% add the cos graph to the existing plot
% tell Matlab to hold the graph for the next plot
hold
%  plot the additional graph, the additional parameter 'r' is for 'red'
plot(x,cos(x),'r');
% add a legend for the two plots
legend('sin(x)','cos(x)')
% correct the title
title('sin and cos graph')

pause, figure
% split the screen into 2 rows and 3 columns of axes, set the next plot to be at
% the first axes
subplot(2,3,1);
% plot a graph of x
plot(x,x);
% Now go to the second axes
subplot(2,3,2);
% plot a graph of x^2
plot(x,x.^2);
% Next, plot a graph of sin in the fifth axes.  Notice, all editing of the graph
% applies only to the current axes
subplot(2,3,5);
% plot a graph of sin(x)
plot(x,y);
% set axis
axis([0 2*pi -1.05 1.05])
% Add a label for the x-axis
xlabel('x');
% Add a label for the y-axis
ylabel('sin(x)');
% Add a title
title('a sinus graph')
